/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.client.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.pipeline.BakedQuadBuilder;
import wayoftime.bloodmagic.common.block.BlockMimic;
import wayoftime.bloodmagic.common.tile.TileMimic;

public class MimicBakedModel
implements IDynamicBakedModel {
    public final ResourceLocation texture;

    public MimicBakedModel(ResourceLocation texture) {
        this.texture = texture;
    }

    private TextureAtlasSprite getTexture() {
        return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(this.texture);
    }

    public boolean m_7547_() {
        return false;
    }

    private void putVertex(BakedQuadBuilder builder, Vec3 normal, double x, double y, double z, float u, float v, TextureAtlasSprite sprite, float r, float g, float b) {
        ImmutableList elements = builder.getVertexFormat().m_86023_().asList();
        block10: for (int j = 0; j < elements.size(); ++j) {
            VertexFormatElement e = (VertexFormatElement)elements.get(j);
            switch (e.m_86048_()) {
                case POSITION: {
                    builder.put(j, new float[]{(float)x, (float)y, (float)z, 1.0f});
                    continue block10;
                }
                case COLOR: {
                    builder.put(j, new float[]{r, g, b, 1.0f});
                    continue block10;
                }
                case UV: {
                    switch (e.m_86049_()) {
                        case 0: {
                            float iu = sprite.m_118367_((double)u);
                            float iv = sprite.m_118393_((double)v);
                            builder.put(j, new float[]{iu, iv});
                            continue block10;
                        }
                        case 2: {
                            builder.put(j, new float[]{0.0f, 0.0f});
                            continue block10;
                        }
                    }
                    builder.put(j, new float[0]);
                    continue block10;
                }
                case NORMAL: {
                    builder.put(j, new float[]{(float)normal.f_82479_, (float)normal.f_82480_, (float)normal.f_82481_});
                    continue block10;
                }
                default: {
                    builder.put(j, new float[0]);
                }
            }
        }
    }

    private BakedQuad createQuad(Vec3 v1, Vec3 v2, Vec3 v3, Vec3 v4, TextureAtlasSprite sprite) {
        Vec3 normal = v3.m_82546_(v2).m_82537_(v1.m_82546_(v2)).m_82541_();
        int tw = sprite.m_118405_();
        int th = sprite.m_118408_();
        BakedQuadBuilder builder = new BakedQuadBuilder(sprite);
        builder.setQuadOrientation(Direction.m_122366_((double)normal.f_82479_, (double)normal.f_82480_, (double)normal.f_82481_));
        this.putVertex(builder, normal, v1.f_82479_, v1.f_82480_, v1.f_82481_, 0.0f, 0.0f, sprite, 1.0f, 1.0f, 1.0f);
        this.putVertex(builder, normal, v2.f_82479_, v2.f_82480_, v2.f_82481_, 0.0f, th, sprite, 1.0f, 1.0f, 1.0f);
        this.putVertex(builder, normal, v3.f_82479_, v3.f_82480_, v3.f_82481_, tw, th, sprite, 1.0f, 1.0f, 1.0f);
        this.putVertex(builder, normal, v4.f_82479_, v4.f_82480_, v4.f_82481_, tw, 0.0f, sprite, 1.0f, 1.0f, 1.0f);
        return builder.build();
    }

    private static Vec3 v(double x, double y, double z) {
        return new Vec3(x, y, z);
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        RenderType layer = MinecraftForgeClient.getRenderType();
        BlockState mimic = (BlockState)extraData.getData(TileMimic.MIMIC);
        if (mimic != null && !(mimic.m_60734_() instanceof BlockMimic)) {
            if (layer == null || ItemBlockRenderTypes.canRenderInLayer((BlockState)mimic, (RenderType)layer)) {
                BakedModel model = Minecraft.m_91087_().m_91289_().m_110907_().m_110893_(mimic);
                try {
                    return model.getQuads(mimic, side, rand, (IModelData)EmptyModelData.INSTANCE);
                }
                catch (Exception e) {
                    return Collections.emptyList();
                }
            }
            return Collections.emptyList();
        }
        if (side != null || layer != null && !layer.equals(RenderType.m_110451_())) {
            return Collections.emptyList();
        }
        TextureAtlasSprite texture = this.getTexture();
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        double l = 0.0;
        double r = 1.0;
        quads.add(this.createQuad(MimicBakedModel.v(l, r, l), MimicBakedModel.v(l, r, r), MimicBakedModel.v(r, r, r), MimicBakedModel.v(r, r, l), texture));
        quads.add(this.createQuad(MimicBakedModel.v(l, l, l), MimicBakedModel.v(r, l, l), MimicBakedModel.v(r, l, r), MimicBakedModel.v(l, l, r), texture));
        quads.add(this.createQuad(MimicBakedModel.v(r, r, r), MimicBakedModel.v(r, l, r), MimicBakedModel.v(r, l, l), MimicBakedModel.v(r, r, l), texture));
        quads.add(this.createQuad(MimicBakedModel.v(l, r, l), MimicBakedModel.v(l, l, l), MimicBakedModel.v(l, l, r), MimicBakedModel.v(l, r, r), texture));
        quads.add(this.createQuad(MimicBakedModel.v(r, r, l), MimicBakedModel.v(r, l, l), MimicBakedModel.v(l, l, l), MimicBakedModel.v(l, r, l), texture));
        quads.add(this.createQuad(MimicBakedModel.v(l, r, r), MimicBakedModel.v(l, l, r), MimicBakedModel.v(r, l, r), MimicBakedModel.v(r, r, r), texture));
        return quads;
    }

    public boolean m_7541_() {
        return true;
    }

    public boolean m_7539_() {
        return false;
    }

    public boolean m_7521_() {
        return false;
    }

    public TextureAtlasSprite m_6160_() {
        return this.getTexture();
    }

    public ItemOverrides m_7343_() {
        return ItemOverrides.f_111734_;
    }

    public ItemTransforms m_7442_() {
        return ItemTransforms.f_111786_;
    }
}

